#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;

#define sz(x) ((int) (x).size())
#define pb push_back
#define mp make_pair
#define fi first
#define se second

#define NAME "j"

const int INF = 1000000000;

int cost[1001];
int w[1001];
int cnt[1001];
bool used[1001];
int col[1001];
vector <int> g[1001];
vector <int> a[1001];
vector <int> G[1001];
vector <int> rg[1001];
vector <int> o;
bool circle[1001];
int COL;
int d[105][20005];
int T;

void dfs1(int u)
{
	used[u] = true;
	for (int i = 0; i < sz(g[u]); ++i)
	{
		int v = g[u][i];
		if (used[v])
			continue;
		dfs1(v);
	}
	o.pb(u);
}

void dfs2(int u)
{
	used[u] = true;
	col[u] = COL;
	a[COL].pb(u);
	for (int i = 0; i < sz(rg[u]); ++i)
	{
		int v = rg[u][i];
		if (used[v])
			continue;
		dfs2(v);
	}
}

vector <pair <int, int> > v_add;
vector <pair <int, int> > v_del;

void clear_q()
{
	v_add.clear();
	v_del.clear();
}

void push(int val, vector <pair <int, int> > &v = v_add)
{
	int best = val;
	if (!v.empty())
		best = max(best, v.back().se);
	v.pb(mp(val, best));
}

void pop()
{
	if (v_del.empty())
	{
		while (!v_add.empty())
		{
			push(v_add.back().fi, v_del);
			v_add.pop_back();
		}
	}
	v_del.pop_back();
}

int q_best()
{
	int res = -INF;
	if (!v_add.empty())
		res = max(res, v_add.back().se);
	if (!v_del.empty())
		res = max(res, v_del.back().se);
	return res;
}

void push_knapsack(int *d, int cost, int w, int max_cnt)
{
	for (int rem = 0; rem < min(w, T + 1); ++rem)
	{
		clear_q();
		int cnt = 0;
		for (int i = rem, iter = 0; i <= T; i += w, ++iter)
		{
			int old_val = d[i];
			d[i] = max(d[i], q_best() + iter * cost);
			push(old_val - iter * cost);
			++cnt;
			if (cnt > max_cnt)
			{
				pop();
				--cnt;
			}
		}
	}
}

void dfs3(int u)
{
	used[u] = true;
	for (int i = 0; i < sz(G[u]); ++i)
	{
		int v = G[u][i];
		if (!used[v])
			dfs3(v);
		for (int j = 0; j <= T; ++j)
			d[u][j] = max(d[u][j], d[v][j]);
//		cerr << "from " << v + 1 << ' ' << "to " << u + 1 << '\n';
	}
	for (int i = 0; i < sz(a[u]); ++i)
	{
		push_knapsack(d[u], cost[a[u][i]], w[a[u][i]], cnt[a[u][i]]);
//		cerr << "push " << u + 1 << ' ' << cost[a[u][i]] << ' ' << cnt[a[u][i]] << ' ' << w[a[u][i]] << '\n';
	}
}

bool solve()
{
	int n, m;
	cin >> n >> m >> T;
	if (!n)
		return false;
	for (int i = 0; i < n; ++i)
	{
		for (int j = 0; j <= T; ++j)
			d[i][j] = 0;
		used[i] = false;
		a[i].clear();
		g[i].clear();
		rg[i].clear();
		scanf("%d%d%d", cost + i, w + i, cnt + i);
	}
	for (int i = 0; i < m; ++i)
	{
		int u, v;
		scanf("%d%d", &u, &v);
		--u, --v;
		g[u].pb(v);
		rg[v].pb(u);
	}
	o.clear();
	for (int i = 0; i < n; ++i)
		if (!used[i])
			dfs1(i);
	reverse(o.begin(), o.end());
	for (int i = 0; i < n; ++i)
		used[i] = false;
	COL = 0;
	for (int i = 0; i < n; ++i)
		if (!used[o[i]])
		{
			dfs2(o[i]);
			COL++;
		}
	for (int i = 0; i < COL; ++i)
	{
		G[i].clear();
		used[i] = false;
		circle[i] = false;
	}
	for (int i = 0; i < n; ++i)
	{
		for (int j = 0; j < sz(g[i]); ++j)
		{
			int v = g[i][j];
			if (col[i] != col[v])
				G[col[v]].pb(col[i]);
			else
				circle[col[i]] = true;
		}
	}
	for (int i = 0; i < COL; ++i)
		if (!circle[i])
		{
			assert(sz(a[i]) == 1);
			cnt[a[i][0]] = min(1, cnt[a[i][0]]);
		}
//	cerr << COL << '\n';
//	for (int i = 0; i < COL; ++i, cerr << '\n')
//		for (int j = 0; j < sz(a[i]); ++j)
//			cerr << a[i][j] << ' ';
	for (int i = 0; i < COL; ++i)
		if (!used[i])
			dfs3(i);
	int ans = 0;
	for (int i = 0; i < COL; ++i)
		for (int j = 0; j <= T; ++j)
			ans = max(ans, d[i][j]);
	cout << ans << '\n';
	return true;
}

int main()
{
	#ifdef LOCAL
	assert(freopen(NAME ".in", "r", stdin));
	#endif // LOCAL
	while (solve());
	#ifdef LOCAL
	cerr << "Time: " << double(clock()) / CLOCKS_PER_SEC << "\n";
	#endif // LOCAL
	return 0;
}
